const crypto = require("crypto");

function verifyNowPaymentsSignature(req) {
  const signature = req.headers["x-nowpayments-sig"];
  if (!signature) return false;

  const sortedBody = JSON.stringify(req.body);
  const expected = crypto
    .createHmac("sha512", process.env.NOWPAYMENTS_IPN_SECRET)
    .update(sortedBody)
    .digest("hex");

  return signature === expected;
}

module.exports = verifyNowPaymentsSignature;
