const User = require("../models/users");
const UserWallet = require("../models/userWallet");


const REFERRAL_BONUS_LEVELS = [
  10.0,  // Level 1
  5.0,   // Level 2
  3.0,   // Level 3
  2.0,   // Level 4
  1.5,   // Level 5
  1.0,   // Level 6
  0.8,   // Level 7
  0.6,   // Level 8
  0.5,   // Level 9
  0.4,   // Level 10
  0.3,   // Level 11
  0.25,  // Level 12
  0.2,   // Level 13
  0.15,  // Level 14
  0.1,   // Level 15
  0.05   // Level 16
];

async function distributeReferralBonus(
  depositor,
  depositAmount,
  session
) {
  let currentReferralId = depositor.referredBy;
  let level = 0;

  while (currentReferralId && level < REFERRAL_BONUS_LEVELS.length) {
    const sponsor = await User.findOne({
      referralId: currentReferralId
    }).session(session);

    if (!sponsor) break;

    const percentage = REFERRAL_BONUS_LEVELS[level];
    const bonusAmount =
      (depositAmount * percentage) / 100;

    if (bonusAmount > 0) {
      const wallet = await UserWallet.findOne({
        userId: sponsor._id
      }).session(session);

      if (wallet) {
        wallet.referralEarnings += bonusAmount;
        await wallet.save({ session });
      }
    }

    // Move up the tree
    currentReferralId = sponsor.referredBy;
    level++;
  }
}

module.exports = distributeReferralBonus;
