const express = require("express");
const { verifyToken } = require("../utils/verifyUser.js");
const {
  adminUpdateWithdrawal,
  deleteWithdrawal,
  getAllWithdrawals,
  getSingleWithdrawal,
  updateWithdrawal,
  withdrawal,
  getUserWithdrawals,
} = require("../controllers/withdrawal.controller.js");

const router = express.Router();

router.post("/withdrawal", verifyToken, withdrawal);
router.post("/update/:id", verifyToken, updateWithdrawal);
router.get("/get/:id", verifyToken, getUserWithdrawals);
router.get("/get", verifyToken, getAllWithdrawals);
router.get("/get-single/:id", verifyToken, getSingleWithdrawal);
router.post("/admin-update/:id", adminUpdateWithdrawal);
router.delete("/delete/:id", deleteWithdrawal);

module.exports = router;
