const express = require("express");
const { createWallet, getAllWallets, getSingleWallet, updateWallet } = require("../controllers/wallet.controller.js");
const { verifyToken } = require("../utils/verifyUser.js");

const router = express.Router();

router.post("/", createWallet);
router.get("/get", verifyToken, getAllWallets);
router.get("/get-single/:id", verifyToken, getSingleWallet);
router.post("/admin-update/:id", updateWallet);

module.exports = router;
