const express = require("express");
const {
  deleteUser,
  getAllUsers,
  getUserById,
  signOut,
  signin,
  signup,
  updateUser,
  updateUserByAdmin,
  forgotPassword,
  resetPassword,
  updateUserROIs,
  updateTransactionPin,
  updatePassword,
  updateUserWallets,
  addReferralCommissionToEarnings,
  getDownlines,
  userWalletData,
} = require("../controllers/users.controller.js");
const { verifyToken } = require("../utils/verifyUser.js");

const router = express.Router();

// User routes
router.post("/signup", signup);
router.post("/signin", signin);
router.get("/signout", signOut);
router.post("/forgot-password", forgotPassword);
router.post("/reset-password", resetPassword);

// User management routes (protected by verifyToken)
router.post("/update/:id", verifyToken, updateUser);
router.put("/referral/earnings", verifyToken, addReferralCommissionToEarnings);
router.post("/update-transaction-pin/:id", verifyToken, updateTransactionPin);
router.post("/update-password/:id", verifyToken, updatePassword);
router.post("/update-wallets/:id", verifyToken, updateUserWallets);
router.get("/wallet-data", verifyToken, userWalletData);

router.get("/get", verifyToken, getAllUsers);
router.get("/downlines", verifyToken, getDownlines);
router.get("/get/:id", verifyToken, getUserById);
router.post("/update-Roi", async (req, res) => {
  const startTime = Date.now();
  try {
    await updateUserROIs();
    const endTime = Date.now();
    console.log(`updateUserROIs executed in ${endTime - startTime} ms`);
    res.status(200).json({ message: "User ROI updated successfully" });
  } catch (error) {
    const endTime = Date.now();
    console.error(`Error in updating ROI after ${endTime - startTime} ms:`, error);
    res.status(500).json({ message: "Error updating ROI" });
  }
});

router.post("/admin-update/:id", updateUserByAdmin);

// User deletion route
router.delete("/delete/:id", deleteUser);

module.exports = router;
