const express = require("express");
const { verifyToken } = require("../utils/verifyUser.js");
const { subscribeToBotPlan, getMySubscriptions, getAllSubscriptionsAdmin, updateSubscriptionAdmin } = require("../controllers/subscriptions.js");

const router = express.Router();

// User routes
router.post("/subscribe", verifyToken, subscribeToBotPlan);
router.get("/my-subscriptions", verifyToken, getMySubscriptions);
router.get("/admin-bot-subscriptions", verifyToken, getAllSubscriptionsAdmin);
router.put("/admin-bot-subscriptions/:id", verifyToken, updateSubscriptionAdmin);

module.exports = router;
