const express = require("express");
const {
  deleteDeposit,
  deposit,
  getAllDeposits,
  getSingleDeposit,
  getUserDeposit,
  updateDeposit,
  updateTotalBalance,
  getCurrencies,
  getDepositStatus,
} = require("../controllers/deposit.controller.js");
const { verifyToken } = require("../utils/verifyUser.js");

const router = express.Router();

router.get("/currencies", getCurrencies);
router.post("/create", verifyToken, deposit);
router.post("/update/:id", verifyToken, updateTotalBalance);
router.get("/get/:id", verifyToken, getUserDeposit);
router.get("/get", verifyToken, getAllDeposits);
router.get("/get-single/:id", verifyToken, getSingleDeposit);
router.get("/status/:orderId", verifyToken, getDepositStatus);
router.post("/admin-update/:id", updateDeposit);
router.delete("/delete/:id", deleteDeposit);

module.exports = router;
