const mongoose = require("mongoose");
const { Schema } = mongoose;

const userWalletSchema = new Schema({
  userId: { 
    type: Schema.Types.ObjectId, 
    ref: "User", 
    unique: true, 
    index: true 
  },

  // Main wallet balance
  balance: { type: Number, default: 0 },

  earnings: { type: Number, default: 0 },

  // Amount currently invested/staked
  activeBalance: { type: Number, default: 0 },

  rankRewards: { type: Number, default: 0 },

  // Total referral income
  referralEarnings: { type: Number, default: 0 },

  // Total amount withdrawn historically
  totalWithdrawn: { type: Number, default: 0 },

  // Pending withdrawals waiting for approval
  pendingWithdrawal: { type: Number, default: 0 }

}, { timestamps: true });

module.exports = mongoose.model("UserWallet", userWalletSchema);
