const mongoose = require('mongoose');
const { Schema } = mongoose;

// Define the Deposit schema
const depositSchema = new Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    required: true,
    ref: 'User',
  },
  amount: {
    type: Number,
    required: true,
  },
  currency: { type: String, required: true },
  // invoiceId: { type: String },
  orderId: { type: String },
  invoiceUrl: { type: String },
  depositAddress: { type: String },
  paymentId: { type: String },
  status: { type: String, enum: ['pending', 'completed', 'failed'], default: 'pending' },

}, { timestamps: true });

// Create the Deposit model
const Deposit = mongoose.model('Deposit', depositSchema);

module.exports = Deposit;
