const mongoose = require("mongoose");
const { Schema } = mongoose;

const botPlanSchema = new Schema(
  {
    name: {
      type: String,
      required: true,
      trim: true,
    },

    slug: {
      type: String,
      required: true,
      unique: true,
      lowercase: true,
      index: true,
    },

    description: {
      type: String,
      default: "",
    },

    // Trades configuration
    minTradesPerDay: {
      type: Number,
      required: true,
      min: 1,
    },

    maxTradesPerDay: {
      type: Number,
      required: true,
      min: 1,
    },

    // Daily ROI %
    dailyRoiPercent: {
      type: Number,
      required: true,
      min: 0,
    },

    // Investment limits
    minAmount: {
      type: Number,
      required: true,
      min: 0,
    },

    maxAmount: {
      type: Number,
      required: true,
      min: 0,
    },

    // Plan duration (null = ongoing)
    durationDays: {
      type: Number,
      default: null,
    },

    // 🔥 NEW: Activation fee (only charged if freeDays === 0)
    activationFee: {
      type: Number,
      default: 0,
      min: 0,
    },

    // 🔥 NEW: Free test days
    freeDays: {
      type: Number,
      default: 0,
      min: 0,
    },

    isActive: {
      type: Boolean,
      default: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("BotPlan", botPlanSchema);
