const SiteData = require("../models/data");

// Create new site data
const createSiteData = async (req, res, next) => {
  try {
    const { websiteName, websiteAddress, websiteLogo } = req.body;

    // Create a new site data entry
    const newSiteData = new SiteData({
      websiteName,
      websiteAddress,
      websiteLogo,
    });

    await newSiteData.save();

    res.status(201).json({
      message: "Site data created successfully",
      siteData: newSiteData,
    });
  } catch (error) {
    console.error("Error creating site data:", error);
    res.status(500).json({ message: "Failed to create site data" });
  }
};

// Get all site data
const getAllSiteData = async (req, res, next) => {
  try {
    // Fetch all site data
    const siteDataList = await SiteData.find();

    // If no site data is found, return an appropriate message
    if (!siteDataList || siteDataList.length === 0) {
      return res.status(404).json({ message: "No site data found" });
    }

    // Return the list of site data in the response
    res.status(200).json({ siteData: siteDataList });
  } catch (error) {
    console.error("Error fetching site data:", error);
    res.status(500).json({ message: "Failed to fetch site data" });
  }
};

// Update existing site data
const updateSiteData = async (req, res, next) => {
  try {
    const { websiteName, websiteAddress } = req.body;

    const updates = {
      websiteName,
      websiteAddress,
    };

    const updatedSiteData = await SiteData.findOneAndUpdate({}, updates, { new: true });

    if (!updatedSiteData) {
      return res.status(404).json({ message: "Site data not found" });
    }

    res.status(200).json({
      message: "Site data updated successfully",
      siteData: updatedSiteData,
    });
  } catch (error) {
    console.error("Error updating site data:", error);
    res.status(500).json({ message: "Failed to update site data" });
  }
};



module.exports = {
  createSiteData,
  getAllSiteData,
  updateSiteData,
};
