// Require necessary packages
const express = require("express");
const mongoose = require('mongoose');
const cors = require('cors');
const userRouter = require("./src/routes/user.route.js");
const botRouter = require("./src/routes/bot.route.js");
const rankRouter = require("./src/routes/rank.route.js");
const subscriptionRouter = require("./src/routes/subscription.route.js");
const depositRouter = require("./src/routes/deposit.route.js");
const withdrawlRouter = require("./src/routes/withdrawal.route.js");
const walletRouter = require("./src/routes/wallet.route.js");
const siteRouter = require("./src/routes/data.route.js");
const schedulerRouter = require("./src/routes/scheduler.route.js");
const webhookRoutes = require("./src/routes/webhook");
const cookieParser = require("cookie-parser");
const { updateUserROIs } = require("./src/scheduler.js");
require('dotenv').config(); // Load .env file

// Connect to MongoDB
mongoose.connect("mongodb+srv://mlm_project:Dreams007@mlmproject.sqhrrv9.mongodb.net/mlm_Project?appName=mlmProject", {
  useNewUrlParser: true,
  useUnifiedTopology: true,
})
  .then(() => {
    console.log("Connected to MongoDB");
  })
  .catch((err) => {
    console.log("Failed to connect to MongoDB", err);
  });

// Initialize Express app
const app = express();

app.use(
  "/api/webhook/nowpayments",
  express.raw({ type: "application/json" })
);

app.use(express.json());

app.use(cookieParser());
app.use(cors({
  origin: 'https://bynax.io',
  // origin: 'http://localhost:5173', 
  credentials: true,  // Allow credentials (cookies)
}));

// Routes
app.use('/api/webhook', webhookRoutes);
app.use("/api/user", userRouter);
app.use("/api/deposit", depositRouter);
app.use("/api/bot", botRouter);
app.use("/api/user-rank", rankRouter);
app.use("/api/subscription", subscriptionRouter);
app.use("/api/withdrawal", withdrawlRouter);
app.use("/api/wallet", walletRouter);
app.use("/api/sitedata", siteRouter);
app.use("/api/cron-job", schedulerRouter);

// Define the cron-job route
app.use('/run-cron', (req, res, next) => {
  updateUserROIs();
  res.status(200).json({ message: "Cron job executed successfully!" });
});



// Set up server
app.listen(4000, () => {
  console.log("Server is running on port 4000");
});


// Global error handling middleware
app.use((err, req, res, next) => {
  const statusCode = err.statusCode || 500;
  const message = err.message || "Internal Server Error";
  return res.status(statusCode).json({
    success: false,
    statusCode,
    message,
  });
});
